(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     39949,       1167]*)
(*NotebookOutlinePosition[     41319,       1206]*)
(*  CellTagsIndexPosition[     41275,       1202]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Una primera visita a las series de Fourier", "Title"],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section",
  InitializationCell->True],

Cell[BoxData[
    \(\(Off[General::spell1];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetOptions[Plot, 
        Background \[Rule] RGBColor[1, 1, 0.75]];\)\)], "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aproximaci\[OAcute]n por polinomios trigonom\[EAcute]tricos", "Section"],

Cell[TextData[{
  "Un",
  StyleBox[" polinomio trigonom\[EAcute]trico",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  " de orden ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es una funci\[OAcute]n de la forma  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontSize->9], 
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", 
              StyleBox["x",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontSize->14,
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontSize->8,
              FontWeight->"Bold"], 
            
            StyleBox[\(a\_0 + \[Sum]\+\(k = 1\)\%n\((a\_k\ \(cos(
                          k\ x)\)\  + \ b\_k\ \(sen(k\ x)\))\)\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_0, \ a\_k, \ b\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  " son n\[UAcute]meros reales llamados coeficientes del polinomio. Aqu\
\[IAcute] tienes algunos ejemplos de polinomios trigonom\[EAcute]tricos y sus \
gr\[AAcute]ficas."
}], "Text"],

Cell[BoxData[
    \(\(Plot[2 - Sin[2  x] + 3  Sin[4  x], {x, \(-3\) \[Pi], 3  \[Pi]}, 
        PlotStyle \[Rule] Hue[ .65]];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[
        1\/2\ Sin[x] + \(2\/5\) Cos[2  x] - 
          3\/10\ Sin[3  x] - \(1\/5\) Cos[4  x] + 
          1\/10\ Sin[5  x], {x, \(-3\) \[Pi], 3  \[Pi]}, 
        PlotStyle \[Rule] Hue[ .65], PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[
        Sin[x] - 
          Cos[x] + \(1\/2\) Sin[2  x] - \(1\/2\) Cos[2  x] + \(1\/3\) 
            Sin[3  x] - \(1\/3\) Cos[3  x], {x, \(-3\) \[Pi], 3  \[Pi]}, 
        PlotStyle \[Rule] Hue[ .65]];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[
        2\ Sin[x] - 
          Sin[2\ x] + \(\(\(2\)\(\ \)\)\/3\) Sin[3\ x] - \(1\/2\) 
            Sin[4\ x] + \(\(\(2\)\(\ \)\)\/5\) 
            Sin[5\ x] - \(1\/\(\(3\)\(\ \)\)\) Sin[6\ x], {x, \(-3\) \[Pi], 
          3  \[Pi]}, PlotStyle \[Rule] Hue[ .65]];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[
        2\ Sin[x] + \(\(\(2\)\(\ \)\)\/\(\(3\)\(\ \)\)\) 
            Sin[3  x] + \(\(\(2\)\(\ \)\)\/\(\(5\)\(\ \)\)\) 
            Sin[5  x], {x, \(-3\) \[Pi], 3  \[Pi]}, 
        PlotStyle \[Rule] Hue[ .65]];\)\)], "Input"],

Cell[TextData[{
  "Como acabas de ver, los polinomios trigonom\[EAcute]tricos pueden tener gr\
\[AAcute]ficas con muy distintos aspectos. Parece razonable conjeturar que, \
eligiendo los coeficientes de forma adecuada, podremos conseguir una buena \
aproximaci\[OAcute]n de una funci\[OAcute]n dada por medio de polinomios \
trigonom\[EAcute]tricos. \nRecuerda que ya sabes c\[OAcute]mo aproximar \
localmente funciones derivables por sus polinomios de Taylor. El problema que \
nos planteamos ahora es parecido: se trata de calcular el polinomio trigonom\
\[EAcute]trico de orden ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que ",
  StyleBox["\"aproxima mejor\"",
    FontSlant->"Italic"],
  " a una funci\[OAcute]n dada ",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". \n",
    FontSlant->"Italic"],
  "Se impone precisar el tipo de aproximaci\[OAcute]n que vamos a considerar. \
Teniendo en cuenta que los polinomios trigonom\[EAcute]tricos tienen per\
\[IAcute]odo ",
  StyleBox["2\[Pi]",
    FontWeight->"Bold"],
  ", trataremos de aproximar la funci\[OAcute]n  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  ",
    FontSlant->"Italic"],
  "en el intervalo",
  StyleBox[" [-\[Pi], \[Pi] ]",
    FontWeight->"Bold"],
  ". Supondremos solamente que ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es continua en dicho intervalo. Como puedes apreciar, a diferencia de los \
polinomio de Taylor que permiten una aproximaci\[OAcute]n local para una \
funci\[OAcute]n que tenga ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " derivadas, ahora queremos una aproximaci\[OAcute]n global, v\[AAcute]lida \
en todo un intervalo, para funciones continuas. \nTodav\[IAcute]a queda por \
aclarar lo m\[AAcute]s importante: \[DownQuestion]de qu\[EAcute] manera vamos \
a medir la aproximaci\[OAcute]n entre la funci\[OAcute]n  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  " y un polinomio trigonom\[EAcute]trico ",
  StyleBox["T ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "?  Pues bien, ",
  StyleBox["vamos a considerar la aproximaci\[OAcute]n en media \
cuadr\[AAcute]tica",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  ". Esto quiere decir que entre todos los polinomios \
trigonom\[EAcute]tricos, ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",",
    FontWeight->"Bold"],
  " de orden ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " vamos a calcular aqu\[EAcute]l que haga m\[IAcute]nima la cantidad ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\ \)\(\(1\/\[Pi]\) \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\((f(x) - 
                        T(x))\)\^2\) \[DifferentialD]x\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Dicho polinomio se llama ",
  StyleBox["polinomio de Fourier",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "de orden",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "de la funci\[OAcute]n ",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"],
  "\nPongamos\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Bold"], 
              StyleBox["x",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontSize->16,
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Bold"], 
            
            StyleBox[\(\[Sum]\+\(k = 0\)\%n\((a\_k\ \(cos(k\ x)\)\  + \ 
                      b\_k\ \(sen(k\ x)\))\) = 
                a\_0 + \[Sum]\+\(k = 1\)\%n\((a\_k\ \(cos(k\ x)\)\  + \ 
                        b\_k\ \(sen(k\ x)\))\)\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  " \n y calculemos los coeficientes de ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "forma que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\(\(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\((f(x) - 
                          T(x))\)\^2\) \[DifferentialD]x\)\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " sea m\[IAcute]nima. Desarrollando el cuadrado, tenemos que:\n",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\(\(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\((f(x) - 
                            T(x))\)\^2\) \[DifferentialD]x\) = \(\(1\/\[Pi]\) \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\( f(
                              x)\)\^2\) \[DifferentialD]x\)\  + \ \
\(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\( T(
                              x)\)\^2\) \[DifferentialD]x\)\  - \ \
\(2\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\( f(x)\) \(T(
                          x)\) \[DifferentialD]x\)\  = \(1\/\[Pi]\) \(\
\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\( f(
                              x)\)\^2\) \[DifferentialD]x\) + \[Sum]\+\(j = 0\
\)\%n\(\[Sum]\+\(k = 0\)\%n\( 
                            a\_j\) \(b\_k\) \(1\/\[Pi]\) \(\[Integral]\_\(-\
\[Pi]\)\%\[Pi]\( cos(j\ x)\) \(sen(
                              k\ x)\) \[DifferentialD]x\)\) + \[Sum]\+\(j = 0\
\)\%n\(\[Sum]\+\(k = 0\)\%n\( 
                            a\_j\) \(a\_k\) \(1\/\[Pi]\) \(\[Integral]\_\(-\
\[Pi]\)\%\[Pi]\( cos(j\ x)\) \(cos(
                              k\ x)\) \[DifferentialD]x\)\) + \
\[IndentingNewLine]\(+\(\[Sum]\+\(j = 0\)\%n\(\[Sum]\+\(k = 0\)\%n\( 
                              b\_j\) \(b\_k\) \(1\/\[Pi]\) \(\[Integral]\_\(-\
\[Pi]\)\%\[Pi]\( sen(j\ x)\) \(sen(
                                k\ x)\) \[DifferentialD]x\)\)\)\)\  - \ \
\[Sum]\+\(k = 0\)\%n\( a\_k\) \(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\( 
                            f(x)\) \(cos(
                            k\ x)\) \[DifferentialD]x\)\  - \ \
\[IndentingNewLine]\(-\ 
                      2\) \(\[Sum]\+\(k = 0\)\%n\( 
                            b\_k\) \(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\
\[Pi]\( f(x)\) \(sen(k\ x)\) \[DifferentialD]x\)\)\)\),
            FontWeight->"Bold"]}], TraditionalForm]]]
}], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "Teniendo en cuenta, como f\[AAcute]cilmente puedes comprobar con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", que ",
  Cell[BoxData[
      StyleBox[\(\[Integral]\_\(-\[Pi]\)\%\[Pi] 
              cos \((jx)\)\ sen \((kx)\) \[DifferentialD]x = 0\),
        FontWeight->"Bold"]]],
  ", ",
  Cell[BoxData[
      \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\( 
                cos\^2\) \((kx)\) \[DifferentialD]x = \(\[Integral]\_\(-\[Pi]\
\)\%\[Pi]\( sen\^2\) \((kx)\) \[DifferentialD]x = \[Pi]\)\)],
    FontWeight->"Bold"],
  "  y, para",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`j \[NotEqual] k\)],
    FontWeight->"Bold"],
  ", ",
  Cell[BoxData[
      StyleBox[\(\[Integral]\_\(-\[Pi]\)\%\[Pi] 
              cos \((jx)\)\ cos \((kx)\) \[DifferentialD]x = \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi] 
                sen \((jx)\)\ sen \((kx)\) \[DifferentialD]x = 0\)\),
        FontWeight->"Bold"]]],
  ". Y poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\_k = \(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\
\%\[Pi]\( f(x)\) \(cos(
                kx)\) \[DifferentialD]x\), \ \[Beta]\_k = \(1\/\[Pi]\) \(\
\[Integral]\_\(-\[Pi]\)\%\[Pi]\( f(x)\) \(sen(kx)\) \[DifferentialD]x\)\)],
    FontWeight->"Bold"],
  ", resulta\n",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\((f(x) - 
                          T(x))\)\^2\) \[DifferentialD]x\) = \(\(1\/\[Pi]\) \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\( f(x)\)\^2\) \[DifferentialD]x\)\  + \ 
                2  a\_0\%2 + \[Sum]\+\(k = 1\)\%n a\_k\%2 + \[Sum]\+\(k = 1\)\
\%n b\_k\%2 - 2 \( a\_0\) \[Alpha]\_0 - 
                2 \(\[Sum]\+\(k = 1\)\%n\( a\_k\) \[Alpha]\_k\) - 
                2 \(\[Sum]\+\(k = 1\)\%n\( 
                          b\_k\) \[Beta]\_k\) = \[IndentingNewLine]\(1\/\[Pi]\
\) \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\(\( f(
                            x)\)\^2\) \[DifferentialD]x\) + \ \[Sum]\+\(k = 1\
\)\%n\((a\_k - \[Alpha]\_k)\)\^2 + \ \[Sum]\+\(k = 1\)\%n\((b\_k - \
\[Beta]\_k)\)\^2\  + 
                2 \((a\_0 - \[Alpha]\_0/2)\)\^2 - \ \[Sum]\+\(k = 0\)\%n \
\[Alpha]\_k\%\(\(2\)\(\ \)\)\  - \ \[Sum]\+\(k = 1\)\%n \[Beta]\_k\%\(\(2\)\(\
\ \)\)\  - \ \[Alpha]\_0\%2/2\)\),
          FontWeight->"Bold"], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "Expresi\[OAcute]n que, evidentemente, es m\[IAcute]nima cuando ",
  Cell[BoxData[
      \(TraditionalForm\`a\_k = \[Alpha]\_k\ , \ b\_k = \[Beta]\_k, \ 
      1 \[LessEqual] \ k \[LessEqual] \ n\)],
    FontWeight->"Bold"],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`a\_0 = \[Alpha]\_0/2\)],
    FontWeight->"Bold"],
  ". Por tanto el polinomio de Fourier de orden",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el polinomio trigonom\[EAcute]trico ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(F\_n\), 
            RowBox[{"(", \(f, x\), 
              StyleBox[")",
                FontSize->16]}]}], 
          "=", \(a\_0 + \[Sum]\+\(k = 1\)\%n\((a\_k\ \(cos(k\ x)\)\  + \ 
                  b\_k\ \(sen(k\ x)\))\)\)}], TraditionalForm]],
    FontWeight->"Bold"],
  "  cuyos coeficientes, llamados ",
  StyleBox["coeficientes de Fourier",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "de",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontSlant->"Italic"],
  "vienen dados por:\n\t\t",
  Cell[BoxData[{
      FormBox[
        StyleBox[\(a\_0 = \(1\/\(2  \[Pi]\)\) \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\( f(x)\) \[DifferentialD]x\)\),
          FontWeight->"Bold"], TraditionalForm], "\[IndentingNewLine]", 
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(a\_k\),
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox[\(1\/\[Pi]\),
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\),
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(f(x)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(cos(k\ x)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontWeight->"Bold"], 
                  StyleBox["      ",
                    FontWeight->"Bold"], 
                  RowBox[{"(", 
                    StyleBox[\(1 \[LessEqual] k \[LessEqual] n\),
                      FontWeight->"Bold"], 
                    StyleBox[")",
                      FontWeight->"Bold"]}]}]}]}]}]}], TraditionalForm], 
    "\[IndentingNewLine]", 
      FormBox[
        StyleBox[\(\(\ \)\(b\_k = \(1\/\[Pi]\) \(\[Integral]\_\(-\[Pi]\)\%\
\[Pi]\( f(x)\) \(sen(
                    k\ x)\) \[DifferentialD]x\ \ \ \ \ \((1 \[LessEqual] 
                      k \[LessEqual] n)\)\)\)\),
          FontWeight->"Bold"], TraditionalForm]}]],
  "\nLos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se llaman ",
  StyleBox["coeficientes coseno ",
    FontWeight->"Bold"],
  "y los ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se llaman ",
  StyleBox["coeficientes seno",
    FontWeight->"Bold"],
  ". Es importante que te des cuenta de que en ning\[UAcute]n momento hemos \
usado la supuesta continuidad de  ",
  StyleBox["f  ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "y que lo \[UAcute]nico necesario  para poder hacer los c\[AAcute]lculos \
anteriores es que las integrales que en ellos aparecen est\[EAcute]n \
definidas, para lo cual ",
  StyleBox["es suficiente que la funci\[OAcute]n ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sea integrable.",
    FontWeight->"Bold"],
  " En particular, tiene perfecto sentido hablar de los coeficientes de \
Fourier de una funci\[OAcute]n mon\[OAcute]tona o de una funci\[OAcute]n \
acotada con un n\[UAcute]mero finito de discontinuidades."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de los coeficientes de Fourier", "Section"],

Cell[TextData[{
  "Para calcular con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " los coeficientes de Fourier de una funci\[OAcute]n  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  " podemos, en principio, definir  "
}], "Text"],

Cell[BoxData[{
    \(\(a[f_, var_, n_Integer] := \(a[f, var, n] = 
          1\/\[Pi]*\(\[Integral]\_\(-\[Pi]\)\%\[Pi] f*
                Cos[n*var] \[DifferentialD]var\)\);\)\), \
"\[IndentingNewLine]", 
    \(\(b[f_, var_, n_Integer] := \(b[f, var, n] = 
          1\/\[Pi]*\(\[Integral]\_\(-\[Pi]\)\%\[Pi] f*
                Sin[n*var] \[DifferentialD]var\)\);\)\)}], "Input"],

Cell[TextData[{
  "El polinomio de Fourier de orden ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " puedes definirlo ahora como"
}], "Text"],

Cell[BoxData[
    \(PoliFourier[f_, var_, n_Integer] := 
      a[f, var, 0]/
          2\  + \ \[Sum]\+\(k = 1\)\%n\((a[f, var, k]*Cos[k*var] + 
              b[f, var, k]*Sin[k*var])\)\)], "Input"],

Cell["\<\
Eval\[UAcute]a la siguiente celda para obtener los primeros diez coeficientes \
coseno de la funci\[OAcute]n identidad\
\>", "Text"],

Cell[BoxData[
    \(Table[a[t, t, k], {k, 10}]\)], "Input"],

Cell[TextData[{
  "Prueba ahora con la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t\^3\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(Table[a[t\^3, t, k], {k, 10}]\)], "Input"],

Cell[TextData[{
  "\[DownQuestion]Sabes interpretar estos resultados? \[DownQuestion]Qu\
\[EAcute] pasar\[AAcute] si calculas los coeficientes seno de las funciones \
",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`t\^4\)],
    FontWeight->"Bold"],
  "? Prueba a ver qu\[EAcute] pasa."
}], "Text"],

Cell[BoxData[
    \(Table[b[t\^2, t, k], {k, 10}]\)], "Input"],

Cell[BoxData[
    \(Table[b[t\^4, t, k], {k, 10}]\)], "Input"],

Cell["\<\
Seguro que ya sabes explicar estos resultados. Ha llegado el momento de que \
calcules polinomios de Fourier. A continuaci\[OAcute]n te propongo algunos. \
Por comodidad, generamos los polinomios de Fourier en una tabla de forma que \
podamos usarlos despu\[EAcute]s para representar sus gr\[AAcute]ficas.\
\>", "Text"],

Cell[BoxData[
    \(\(Table[idf[k] = PoliFourier[t, t, k], {k, 6}];\)\)], "Input"],

Cell["Si quieres, puedes ver alguno de los polinomios obtenidos.", "Text"],

Cell[BoxData[
    \(idf[5]\)], "Input"],

Cell["\<\
Ahora representamos las gr\[AAcute]ficas de los seis polinomios y de la funci\
\[OAcute]n identidad.\
\>", "Text"],

Cell[BoxData[
    \(Do[Plot[{t, idf[k]}, {t, \(-\[Pi]\), \[Pi]}, 
        PlotRange \[Rule] {\(-\[Pi]\) -  .5, \[Pi] +  .5}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .7]}, 
        Background \[Rule] RGBColor[1, 1, 0.75]], {k, 6}]\)], "Input"],

Cell[TextData[{
  "Ahora puedes experimentar con distintas funciones. Utiliza funciones polin\
\[OAcute]micas sencillas como ",
  Cell[BoxData[
      \(TraditionalForm\`t\^3\)],
    FontWeight->"Bold"],
  " o  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t\^2 + t\^3\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Tambi\[EAcute]n puedes usar la funci\[OAcute]n exponencial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Exp[t]\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", o ",
  StyleBox["Exp[-t]Sin[t] ",
    FontWeight->"Bold"],
  "e incluso la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Exp[Sin[t]]\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". La aproximaci\[OAcute]n de esta \[UAcute]ltima es sorprendente. S\
\[EAcute] paciente, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " necesita un minuto para hacer los c\[AAcute]lculos."
}], "Text"],

Cell[BoxData[
    \(\(Table[
        expsinf[k] = PoliFourier[Exp[Sin[t]], t, k], {k, 3}];\)\)], "Input"],

Cell[TextData[{
  "Puedes ver los polinomios obtenidos y comprobar\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha usado unas funciones, llamadas funciones de Bessel, para calcular de \
forma simb\[OAcute]lica exacta los coeficientes."
}], "Text"],

Cell[BoxData[
    \(expsinf[3]\)], "Input"],

Cell["\<\
Si quieres, puedes obtener los polinomios con aproximaciones \
num\[EAcute]ricas de los coeficientes.\
\>", "Text"],

Cell[BoxData[
    \(expsinf[3] // N\)], "Input"],

Cell["Representemos las aproximaciones obtenidas.", "Text"],

Cell[BoxData[
    \(Do[Plot[{Exp[Sin[t]], expsinf[k]}, {t, \(-\[Pi]\), \[Pi]}, 
        PlotRange \[Rule] {\(-\[Pi]\) -  .5, \[Pi] +  .5}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .7]}, 
        Background \[Rule] RGBColor[1, 1, 0.75]], {k, 1, 3}]\)], "Input"],

Cell[TextData[{
  "Es llamativo c\[OAcute]mo el tercer polinomio de Fourier casi coincide con \
la funci\[OAcute]n en el intervalo",
  StyleBox[" [-\[Pi], \[Pi] ]",
    FontWeight->"Bold"],
  ". Hagamos una prueba m\[AAcute]s todav\[IAcute]a con la funci\[OAcute]n \
valor absoluto que en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se escribe Abs[t]."
}], "Text"],

Cell[BoxData[
    \(\(Table[
        valorabsf[k] = PoliFourier[Abs[t], t, k], {k, 1, 7, 2}];\)\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{Abs[t], valorabsf[k]}, {t, \(-\[Pi]\), \[Pi]}, 
        PlotRange \[Rule] {\(- .2\), \[Pi] +  .2}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .7]}, 
        Background \[Rule] RGBColor[1, 1, 0.75], 
        AspectRatio \[Rule] Automatic], {k, 1, 7, 2}]\)], "Input"],

Cell["Sorprendente, \[DownQuestion]verdad?.", "Text"],

Cell[TextData[{
  "Tambi\[EAcute]n puedes obtener los coeficientes de Fourier y los \
polinomios de Fourier usando comandos propios de ",
  StyleBox["Mathematica:",
    FontSlant->"Italic"],
  " \"FourierCosCoefficient[expr, t, n]\",\"FourierSinCoefficient[expr, t, n]\
\", ",
  "\"FourierTrigSeries[expr, t, k]\".",
  " Para ello, antes que nada, hay que cargar dichos comandos lo que puedes \
hacer evaluando la siguiente celda."
}], "Text"],

Cell[BoxData[
    \(<< Calculus`FourierTransform`\)], "Input"],

Cell[TextData[{
  "Ahora puedes pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que te informe de lo que hacen los comandos anteriores."
}], "Text"],

Cell[BoxData[
    \(Information[FourierCosCoefficient, LongForm \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Information[FourierTrigSeries, LongForm \[Rule] False]\)], "Input"],

Cell[TextData[{
  "Para ajustar estos comandos al intervalo ",
  StyleBox["[-\[Pi], \[Pi]]",
    FontWeight->"Bold"],
  " hay que modificar los par\[AAcute]metros por defecto."
}], "Text"],

Cell[BoxData[
    \(FourierTrigSeries[t\^2 + t\^3, t, 10, 
      FourierParameters \[Rule] {\(-1\), 1/\((2  \[Pi])\)}]\)], "Input"],

Cell["\<\
Comprueba que si haces el c\[AAcute]lculo con el comando \"PoliFourier\" \
antes definido obtienes el mismo resultado.\
\>", "Text"],

Cell[BoxData[
    \(PoliFourier[t\^2 + t\^3, t, 10]\)], "Input"],

Cell[TextData[{
  "Los polinomios de Fourier son particularmente apropiados para representar \
ondas y aproximar funciones oscilatorias o peri\[OAcute]dicas. Una manera c\
\[OAcute]moda de representar estas funciones con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es usando la funci\[OAcute]n de Heaviside \"UnitStep[x]\" que es igual a \
1 si ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] 0\)],
    FontWeight->"Bold"],
  " e igual a",
  StyleBox[" 0",
    FontWeight->"Bold"],
  " para ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x < 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Aqu\[IAcute] puedes ver unos ejemplos. Procura entenderlos."
}], "Text"],

Cell[BoxData[{
    \(\(graf1 = 
        Plot[UnitStep[\((x - \[Pi]/2)\) 
              x \((x + \[Pi]/2)\)], {x, \(-\[Pi]\), \[Pi]}, 
          PlotStyle \[Rule] Hue[ .65], 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          PlotRange \[Rule] {\(- .2\), 1.2}, 
          AxesOrigin \[Rule] {0, \(- .1\)}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        Plot[\((Pi^2/4 - \((x + \[Pi]/2)\)^2)\)*
              UnitStep[\(-\((x + \[Pi])\)\) 
                  x] + \((Pi^2/4 - \((x - \[Pi]/2)\)^2)\)*
              UnitStep[\(-\((x - \[Pi])\)\) x], {x, \(-\[Pi]\), \[Pi]}, 
          PlotStyle \[Rule] Hue[ .65], PlotRange \[Rule] {\(- .1\), 2.7}, 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{graf1, graf2}], 
        ImageSize \[Rule] {544, 159}];\)\), "\[IndentingNewLine]", 
    \(\(Clear[graf1, graf2];\)\)}], "Input"],

Cell[TextData[{
  "Observa que en la gr\[AAcute]fica de la izquierda ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " une mediante un segmento vertical los puntos de salto de la \
funci\[OAcute]n. Observa que se trata de dos funciones peri\[OAcute]dicas con \
per\[IAcute]odo",
  StyleBox[" \[Pi]",
    FontWeight->"Bold"],
  ". Eval\[UAcute]a la siguiente celda para ver las aproximaciones de dichas \
funciones por sus polinomios de Fourier. Ten paciencia, tarda un minuto, casi \
una eternidad cuando est\[AAcute]s delante de la pantalla de un ordenador."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[f, g];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := UnitStep[\((x - \[Pi]/2)\) x \((x + \[Pi]/2)\)];\)\), "\n", 
    \(\(g[
          x_] := \((Pi^2/4 - \((x + \[Pi]/2)\)^2)\)*
            UnitStep[\(-\((x + \[Pi])\)\) 
                x] + \((Pi^2/4 - \((x - \[Pi]/2)\)^2)\)*
            UnitStep[\(-\((x - \[Pi])\)\) x];\)\), "\[IndentingNewLine]", 
    \(\(Table[polif[k] = PoliFourier[f[x], x, 3  k], {k, 2, 5}];\)\), "\n", 
    \(\(Table[
        polig[k] = PoliFourier[g[x], x, k], {k, 2, 
          5}];\)\), "\[IndentingNewLine]", 
    \(\(Table[
        graf1[k] = 
          Plot[{f[x], polif[k]}, {x, \(-\[Pi]\), \[Pi]}, 
            PlotRange \[Rule] {\(- .2\), 1.2}, 
            AxesOrigin \[Rule] {0, \(- .1\)}, 
            PlotStyle \[Rule] {Hue[ .65], Hue[0]}, 
            Background \[Rule] RGBColor[1, 1, 0.75], 
            DisplayFunction \[Rule] Identity], {k, 2, 
          5}];\)\), "\[IndentingNewLine]", 
    \(\(Table[
        graf2[k] = 
          Plot[{g[x], polig[k]}, {x, \(-\[Pi]\), \[Pi]}, 
            PlotStyle \[Rule] {Hue[ .65], Hue[0]}, 
            PlotRange \[Rule] {\(- .1\), 2.7}, 
            Background \[Rule] RGBColor[1, 1, 0.75], 
            DisplayFunction \[Rule] Identity], {k, 2, 
          5}];\)\), "\[IndentingNewLine]", 
    \(\(Do[
        Show[GraphicsArray[{graf1[k], graf2[k]}], 
          ImageSize \[Rule] {544, 159}], {k, 2, 5}];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series de Fourier", "Section"],

Cell[TextData[{
  "Al igual que los polinomios de Taylor conducen a las series de Taylor, los \
polinomios de Fourier conducen de manera natural a las series de Fourier. La \
serie de Fourier de una funci\[OAcute]n integrable  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  es la sucesi\[OAcute]n de sus polinomios de Fourier, es decir, es la \
serie de funciones  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_0 + \[Sum]\+\(k \[GreaterSlantEqual] 1\)\((a\_k\ \(cos(
                      k\ x)\)\  + \ b\_k\ \(sen(k\ x)\))\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde los coeficientes viene dados por\n\t\t\t\t",
  Cell[BoxData[{
      FormBox[
        StyleBox[\(a\_0 = \(1\/\(2  \[Pi]\)\) \
\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\( f(x)\) \[DifferentialD]x\)\),
          FontWeight->"Bold"], TraditionalForm], "\[IndentingNewLine]", 
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(a\_k\),
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox[\(1\/\[Pi]\),
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\),
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(f(x)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(cos(k\ x)\),
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["\[DifferentialD]",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["x",
                        FontWeight->"Bold"], 
                      StyleBox[
                        RowBox[{
                          StyleBox["    ",
                            FontWeight->"Bold"], 
                          StyleBox[" ",
                            FontWeight->"Bold"]}]], 
                      StyleBox["(",
                        FontWeight->"Bold"], 
                      StyleBox[\(k \[GreaterEqual] 1\),
                        FontWeight->"Bold"], 
                      StyleBox[")",
                        FontWeight->"Bold"]}]}]}]}]}]}], 
          StyleBox[
            RowBox[{
              StyleBox["  ",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"]}]]}], TraditionalForm], 
    "\[IndentingNewLine]", 
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(b\_k\),
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox[\(1\/\[Pi]\),
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\),
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(f(x)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(sen(k\ x)\),
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["\[DifferentialD]",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["x",
                        FontWeight->"Bold"], 
                      StyleBox[
                        RowBox[{
                          StyleBox["    ",
                            FontWeight->"Bold"], 
                          StyleBox["  ",
                            FontWeight->"Bold"]}]], 
                      StyleBox["(",
                        FontWeight->"Bold"], 
                      StyleBox[\(k \[GreaterEqual] 1\),
                        FontWeight->"Bold"], 
                      StyleBox[")",
                        FontWeight->"Bold"]}]}]}]}]}]}]}], 
        TraditionalForm]}]]
}], "Text"],

Cell[TextData[{
  "Lo sorprendente es que, mientras las series de Taylor s\[OAcute]lo sirven \
para representar localmente a las funciones anal\[IAcute]ticas, es posible ",
  StyleBox["\"representar\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de forma ",
  StyleBox["\"global\"",
    FontSlant->"Italic"],
  " funciones mucho m\[AAcute]s generales por series de Fourier. La cuesti\
\[OAcute]n est\[AAcute] en precisar qu\[EAcute] se entiende por ",
  StyleBox["\"representar\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "F\[IAcute]jate que con las series de Taylor esta cuesti\[OAcute]n ni \
siquiera se plantea porque la convergencia de dichas series es siempre \
uniforme en intervalos cerrados y acotados contenidos en su intervalo de \
convergencia y, por ello, las series de Taylor proporcionan una representaci\
\[OAcute]n",
  StyleBox[" \"\[OAcute]ptima\"",
    FontSlant->"Italic"],
  ". Es justamente la posibilidad de representar globalmente funciones por \
medio de series de Fourier ",
  StyleBox["con tipos de convergencia m\[AAcute]s d\[EAcute]biles",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que la uniforme lo que hace de dichas series una herramienta muy general \
y de gran utilidad para tratar una gran variedad de problemas.\nEl estudio de \
los distintos tipos de convergencia de las series de Fourier no es propio de \
un curso de C\[AAcute]lculo y requiere como herramienta b\[AAcute]sica la \
integral de Lebesgue. Lo que s\[IAcute] debes saber es que no hay garant\
\[IAcute]a de que la serie de Fourier de una funci\[OAcute]n integrable, \
continua incluso, converja puntualmente a dicha funci\[OAcute]n. Se necesita \
imponer algunas condiciones a una funci\[OAcute]n para que su serie de \
Fourier converja puntualmente a ella. El siguiente resultado es de los m\
\[AAcute]s \[UAcute]tiles en este sentido. "
}], "Text"],

Cell[TextData[{
  StyleBox["Teorema",
    FontWeight->"Bold"],
  ". Sea",
  StyleBox[" f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " una funci\[OAcute]n continua en",
  StyleBox[" [-\[Pi], \[Pi]]",
    FontWeight->"Bold"],
  ". Supongamos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(\(-\[Pi]\)) = f(\[Pi])\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y que hay una partici\[OAcute]n del intervalo",
  StyleBox[" [-\[Pi], \[Pi]]",
    FontWeight->"Bold"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0 = \(\(\(-\[Pi]\) < t\_1 < t\_2 <  ... \) < 
            t\_\(n - 1\) < t\_n = \[Pi]\)\)],
    FontWeight->"Bold"],
  ", tal que ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "tiene derivada continua en cada intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([t\_\(k - 1\), t\_k]\)\)],
    FontWeight->"Bold"],
  " de dicha partici\[OAcute]n. E",
  "ntonces se verifica que la serie de Fourier de  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " converge uniformemente a  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "en el intervalo ",
  StyleBox["[-\[Pi], \[Pi]]",
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Calculemos la serie de Fourier de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\) = x\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Como es una funci\[OAcute]n par sabemos que los coeficientes seno son \
nulos. Como queremos calcular simb\[OAcute]licamente los coeficientes \
a[f,var,n], b[f,var,n] sin atribuir ning\[UAcute]n valor al entero",
  StyleBox[" n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " hay que modificar las definiciones dadas al principio. Tambi\[EAcute]n es \
necesario sustituir ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(cos(n\ \[Pi])\),
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\))\)\^n\)],
    FontWeight->"Bold"],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(sen(n\ \[Pi])\),
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  StyleBox["0",
    FontWeight->"Bold"],
  ". En algunos casos deber\[AAcute]s ayudar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para sustituir ",
  Cell[BoxData[
      \(TraditionalForm\`1 + \((\(-1\))\)\^n\)],
    FontWeight->"Bold"],
  "por",
  StyleBox[" 2",
    FontWeight->"Bold"],
  " o por ",
  StyleBox["0",
    FontWeight->"Bold"],
  " seg\[UAcute]n proceda."
}], "Text"],

Cell[BoxData[{
    \(\(sustitucion = {Cos[n*\[Pi]] \[RuleDelayed] \((\(-1\))\)\^n, 
          Sin[n*\[Pi]] \[RuleDelayed] 0};\)\), "\[IndentingNewLine]", 
    \(a[x\^2, x, 0]/2\), "\[IndentingNewLine]", 
    \(a[x\^2, x, n] = 
      Integrate[\(1\/\[Pi]\) \(x\^2\) Cos[n*x], {x, \(-\[Pi]\), \[Pi]}, \ 
          Assumptions \[Rule] n \[Element] Integers\  && \ n > 0\ ] /. 
        sustitucion\)}], "Input"],

Cell[TextData[{
  "En virtud del teorema anterior, obtenemos que   ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\^2 = \[Pi]\^2\/3 + \[Sum]\+\(n = 1\)\%\[Infinity]\(\( 
                        4\ \((\(-1\))\)\^n\)\/n\^2\) \(cos(n\ x)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "  para todo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x \[Element] \([\(-\[Pi]\), \[Pi]]\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  " y la convergencia es uniforme en dicho intervalo. En particular, haciendo \
",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", se deduce que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(n = 1\)\%\[Infinity]\((\(-1\))\)\^\(n + \
1\)\/n\^2 = \[Pi]\^2\/12\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio",
    FontWeight->"Bold"],
  ". Obtener las series de Fourier de las funciones ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(x\)\(|\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " , ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(sen\ x\)\(|\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", y ",
  Cell[BoxData[
      \(\((x\^2/2 - \[Pi]\ x)\) 
          UnitStep[x \((\[Pi] - x)\)] + \((x\^2/2 + \[Pi]\ x)\) 
          UnitStep[\(-x\) \((\[Pi] + x)\)]\)],
    FontWeight->"Bold"],
  ". Deducir el valor de los l\[IAcute]mites ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(n = 1\)\%\[Infinity] 1\/\((2  n - 1)\)\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(n = 1\)\%\[Infinity] 1\/\(4  n\^2 - 1\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(n = 1\)\%\[Infinity] 1\/n\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". "
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 877}},
AutoGeneratedPackage->None,
WindowSize->{1272, 843},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{2, 2},
PageHeaders->{{Cell[ 
        TextData[ {"Series de Fourier"}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}, {Cell[ 
        TextData[ {"Series de Fourier"}], "Header"], Inherited, Inherited}},
PageFooters->{{Cell[ 
        TextData[ {"Dpto. An\[AAcute]lisis Matem\[AAcute]tico"}], "Header"], 
      Inherited, Cell[ 
        TextData[ {"Javier P\[EAcute]rez"}], "Header"]}, {Cell[ 
        TextData[ {"Dpto. An\[AAcute]lisis Matem\[AAcute]tico"}], "Header"], 
      Inherited, Cell[ 
        TextData[ {"Javier P\[EAcute]rez"}], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 59, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1838, 55, 69, 1, 93, "Section",
  InitializationCell->True],
Cell[1910, 58, 86, 2, 72, "Input",
  InitializationCell->True],
Cell[1999, 62, 132, 3, 72, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[2168, 70, 78, 0, 93, "Section"],
Cell[2249, 72, 1244, 39, 68, "Text"],
Cell[3496, 113, 139, 2, 72, "Input"],
Cell[3638, 117, 257, 5, 126, "Input"],
Cell[3898, 124, 243, 5, 126, "Input"],
Cell[4144, 131, 306, 6, 127, "Input"],
Cell[4453, 139, 253, 5, 96, "Input"],
Cell[4709, 146, 6753, 183, 632, "Text"],
Cell[11465, 331, 2324, 54, 189, "Text"],
Cell[13792, 387, 4098, 121, 313, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17927, 513, 65, 0, 93, "Section"],
Cell[17995, 515, 307, 11, 42, "Text"],
Cell[18305, 528, 379, 7, 149, "Input"],
Cell[18687, 537, 241, 10, 42, "Text"],
Cell[18931, 549, 198, 4, 134, "Input"],
Cell[19132, 555, 142, 3, 41, "Text"],
Cell[19277, 560, 59, 1, 72, "Input"],
Cell[19339, 563, 184, 7, 41, "Text"],
Cell[19526, 572, 62, 1, 73, "Input"],
Cell[19591, 575, 451, 15, 41, "Text"],
Cell[20045, 592, 62, 1, 73, "Input"],
Cell[20110, 595, 62, 1, 73, "Input"],
Cell[20175, 598, 329, 5, 67, "Text"],
Cell[20507, 605, 82, 1, 72, "Input"],
Cell[20592, 608, 74, 0, 41, "Text"],
Cell[20669, 610, 39, 1, 72, "Input"],
Cell[20711, 613, 124, 3, 41, "Text"],
Cell[20838, 618, 243, 4, 98, "Input"],
Cell[21084, 624, 937, 29, 67, "Text"],
Cell[22024, 655, 105, 2, 72, "Input"],
Cell[22132, 659, 275, 6, 67, "Text"],
Cell[22410, 667, 43, 1, 72, "Input"],
Cell[22456, 670, 125, 3, 41, "Text"],
Cell[22584, 675, 48, 1, 72, "Input"],
Cell[22635, 678, 59, 0, 41, "Text"],
Cell[22697, 680, 260, 4, 98, "Input"],
Cell[22960, 686, 379, 10, 67, "Text"],
Cell[23342, 698, 108, 2, 72, "Input"],
Cell[23453, 702, 292, 5, 98, "Input"],
Cell[23748, 709, 53, 0, 41, "Text"],
Cell[23804, 711, 443, 10, 93, "Text"],
Cell[24250, 723, 62, 1, 72, "Input"],
Cell[24315, 726, 169, 5, 41, "Text"],
Cell[24487, 733, 91, 1, 72, "Input"],
Cell[24581, 736, 87, 1, 72, "Input"],
Cell[24671, 739, 188, 5, 41, "Text"],
Cell[24862, 746, 131, 2, 73, "Input"],
Cell[24996, 750, 142, 3, 41, "Text"],
Cell[25141, 755, 64, 1, 73, "Input"],
Cell[25208, 758, 710, 20, 93, "Text"],
Cell[25921, 780, 992, 19, 276, "Input"],
Cell[26916, 801, 580, 12, 93, "Text"],
Cell[27499, 815, 1440, 31, 332, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28976, 851, 36, 0, 93, "Section"],
Cell[29015, 853, 3969, 104, 220, "Text"],
Cell[32987, 959, 1929, 38, 290, "Text"],
Cell[34919, 999, 1241, 44, 96, "Text"],
Cell[36163, 1045, 1336, 44, 94, "Text"],
Cell[37502, 1091, 407, 7, 150, "Input"],
Cell[37912, 1100, 911, 27, 98, "Text"],
Cell[38826, 1129, 1107, 35, 117, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

